<?php

/**
 * Created by PhpStorm.
 * User: Pablo García Sanz
 * Date: 26/08/2017
 * Time: 17:45
 */
class FooterLanguage
{
    private $language;
    private $CI;

    public function __construct()
    {

        $this->CI = get_instance();
        $this->language = $this->CI->session->userdata('language');
        $this->CI->load->language('footer_lang', $this->language);
    }

    /**
     * Funcion que devuelve, accediendo al diccionario de datos, los mensajes de error
     * @return MensajesError []
     */
    public function getErrorMessages()
    {
        $data['footer_toast_error_mail'] = $this->CI->lang->line('footer_toast_error_mail');
        $data['footer_toast_error_team_exists'] = $this->CI->lang->line('footer_toast_error_team_exists');
        $data['footer_toast_error_delete_team'] = $this->CI->lang->line('footer_toast_error_delete_team');
        $data['footer_toast_error_update_team'] = $this->CI->lang->line('footer_toast_error_update_team');
        $data['footer_toast_error_dni_exists'] = $this->CI->lang->line('footer_toast_error_dni_exists');
        $data['footer_toast_error_create_referee'] = $this->CI->lang->line('footer_toast_error_create_referee');
        $data['footer_toast_error_delete_referee'] = $this->CI->lang->line('footer_toast_error_delete_referee');
        $data['footer_toast_error_update_referee'] = $this->CI->lang->line('footer_toast_error_update_referee');
        $data['footer_toast_error_old_password'] = $this->CI->lang->line('footer_toast_error_old_password');
        $data['footer_toast_error_create_competition'] = $this->CI->lang->line('footer_toast_error_create_competition');
        $data['footer_toast_error_delete_competition'] = $this->CI->lang->line('footer_toast_error_delete_competition');
        $data['footer_toast_error_add_referee_inscription'] = $this->CI->lang->line('footer_toast_error_add_referee_inscription');
        $data['footer_toast_error_delete_referee_inscription'] = $this->CI->lang->line('footer_toast_error_delete_referee_inscription');
        $data['footer_toast_error_session_expired'] = $this->CI->lang->line('footer_toast_error_session_expired');
        $data['footer_toast_error_exists_participation'] = $this -> CI->lang->line('footer_toast_error_exists_participation');
        $data['footer_toast_error_competition_exists'] = $this -> CI->lang->line('footer_toast_error_competition_exists');

        $data['footer_toast_error_equal_competitor'] = $this -> CI->lang->line('footer_toast_error_equal_competitor');
        $data['footer_toast_error_create_timekeeper'] = $this -> CI->lang->line('footer_toast_error_create_timekeeper');
        $data['footer_toast_error_no_size_dni'] = $this -> CI->lang->line('footer_toast_error_no_size_dni');

//        $data[''] = $this -> CI->lang->line('');


        return $data;
    }
    /**
     * Funcion que devuelve, accediendo al diccionario de datos, los mensajes de validez
     * @return MensajesOk []
     */
    public function getSuccessMessages()
    {
        $data['footer_toast_success_change_password'] = $this->CI->lang->line('footer_toast_success_change_password');
        $data['footer_toast_success_create_team'] = $this->CI->lang->line('footer_toast_success_create_team');
        $data['footer_toast_success_delete_team'] = $this->CI->lang->line('footer_toast_success_delete_team');
        $data['footer_toast_success_update_team'] = $this->CI->lang->line('footer_toast_success_update_team');
        $data['footer_toast_success_create_referee'] = $this->CI->lang->line('footer_toast_success_create_referee');
        $data['footer_toast_success_delete_referee'] = $this->CI->lang->line('footer_toast_success_delete_referee');
        $data['footer_toast_success_update_referee'] = $this->CI->lang->line('footer_toast_success_update_referee');
        $data['footer_toast_success_create_competition'] = $this->CI->lang->line('footer_toast_success_create_competition');
        $data['footer_toast_success_delete_competition'] = $this->CI->lang->line('footer_toast_success_delete_competition');
        $data['footer_toast_success_referee_inscription'] = $this->CI->lang->line('footer_toast_success_referee_inscription');
        $data['footer_toast_success_delete_referee_inscription'] = $this -> CI->lang->line('footer_toast_success_delete_referee_inscription');
        $data['footer_toast_success_competitor_inscription'] = $this -> CI->lang->line('footer_toast_success_competitor_inscription');
        $data['footer_toast_success_delete_competitor_inscription'] = $this -> CI->lang->line('footer_toast_success_delete_competitor_inscription');
        $data['footer_toast_success_add_referee_category'] = $this -> CI->lang->line('footer_toast_success_add_referee_category');

        $data['footer_toast_success_create_timekeeper'] = $this -> CI->lang->line('footer_toast_success_create_timekeeper');
        $data['footer_toast_success_add_timekeeper_to_mat'] = $this -> CI->lang->line('footer_toast_success_add_timekeeper_to_mat');
        $data['footer_toast_success_delete_timekeeper_to_mat'] = $this -> CI->lang->line('footer_toast_success_delete_timekeeper_to_mat');
        $data['footer_toast_success_create_combat'] = $this -> CI->lang->line('footer_toast_success_create_combat');
        $data['footer_toast_success_add_score'] = $this -> CI->lang->line('footer_toast_success_add_score');
        $data['footer_toast_success_update_mat'] = $this -> CI->lang->line('footer_toast_success_update_mat');
        $data['footer_toast_success_enter_position'] = $this -> CI->lang->line('footer_toast_success_enter_position');

        $data['footer_toast_success_delete_combat'] = $this -> CI -> lang -> line('footer_toast_success_delete_combat');

        return $data;
        //        $data[''] = $this -> CI->lang->line('');

    }

    /**
     * Funcion que devuelve el texto, accediendo al diccionario de datos
     * @return MensajesAdvertencia
     */
    public function getWarningMessages() {
        $data['footer_toast_warning_no_select_algorithm'] = $this -> CI -> lang -> line('footer_toast_warning_no_select_algorithm');
        $data['footer_toast_warning_error_can_not_generate'] = $this -> CI -> lang -> line('footer_toast_warning_error_can_not_generate');
        $data['footer_toast_no_connect'] = $this -> CI -> lang -> line('footer_toast_no_connect');
        return $data;
    }

    /**
     * Funcion que devuelve el texto, accediendo al diccionario de datos
     * @return MensajesInfo []
     */
    public function getInfoMessages() {
        $data['footer_toast_recovery_password_sent'] = $this->CI->lang->line('footer_toast_recovery_password_sent');
        return $data;
    }
    /**
     * Funcion que devuelve el texto, accediendo al diccionario de datos
     * @return MensajesFooter []
     */
    public function getFooterMsg() {
        $data['footer_contact'] = $this->CI->lang->line('footer_contact');
        $data['footer_school'] = $this->CI->lang->line('footer_school');
        return $data;
    }
}